| package |
package := Package name: 'Pst-PalmOS-Dolphin'.
package paxVersion: 0;
	basicComment: ''.

package basicPackageVersion: ''.

"Add the package scripts"

"Add the class names, loose method names, global names, resource names"
package classNames
	yourself.

package methodNames
	add: #PstConstantsBrowser -> #addResourceDatabase;
	add: #PstLauncher -> #newProjectPalmOS;
	yourself.

package globalNames
	yourself.

package resourceNames
	yourself.

"Binary Global Names"
package binaryGlobalNames: (Set new
	yourself).
"Resource Names"
package allResourceNames: (Set new
	yourself).

"Add the prerequisite names"
package setPrerequisites: (IdentitySet new
	add: 'Dolphin';
	add: 'Pst-Base';
	add: 'Pst-PalmOS-Base';
	add: 'Pst-Ui-Dolphin';
	yourself).

package!

"Class Definitions"!

"Loose Methods"!

!PstConstantsBrowser methodsFor!

addResourceDatabase
	| filename name |

	filename := FileOpenDialog new
		fileTypes: (Array
			with: #('PalmOS Resource Databases (*.prc)' '*.prc')
			with: #('PalmOS Resources (*.bin)' '*.bin')
			with: FileDialog allFilesType);
		caption: 'Select Resource Database';
		defaultExtension: 'prc';
		showModal.
	(filename isNil or: [filename isEmpty]) ifTrue: [^self].
	self model ensureCategoryExists: 'Resource Databases'.
	name := self model nextResourceDBConstantName.
	self model
		define: name
		as: (PstByteIndexableObject newString: filename)
		classified: 'Resource Databases'.
	self selectConstant: (self model constantNamed: name).! !
!PstConstantsBrowser categoriesFor: #addResourceDatabase!actions!public! !

!PstLauncher methodsFor!

newProjectPalmOS

	self newProjectOfType: PstPocketSmalltalkPalmOS.! !
!PstLauncher categoriesFor: #newProjectPalmOS!actions-system!public! !

"End of package definition"!

 
"Binary Globals"!

"Resources"!

